      Subroutine libver( trans, m, n, a, lda, x, y, nrep, extime,
     &                   perfor )
! ----------------------------------------------------------------------
! --- This routine performs the timing and calculates the performance
!     of the Special library version of Matrix-Vector multiplication
!     routine DGEMV.
*** If DGEMV is not available, replace it with the appropriate ***
*** equivalent.                                                 ***
!
!    Parameters
!    ==========
!
!    TRANS  - Input  - Determines the operation te be performed by MVSR
!    M, N   - Input  - Dimension of the problem
!    A(M,N) - Input  - Contains the matrix A
!    LDA    - Input  - Leading Dimension of A
!    X(*)   - Input  - Contains the vector x
!    Y(*)   - Output - Contains result vector y
!    NREP   - Input  - The initial repetition factor to increase 
!                      accuracy of the timing
!    EXTIME - Output - Contains the execution time for the operation
!    PERFOR - Output - Contains the performance in Mflop/s
! ----------------------------------------------------------------------
      Use                    numerics
      Include                'mpif.h'

      Character*1         :: trans
      Integer             :: m, n, lda, nrep
      Real(l_)            :: a(lda,*), x(*), y(*)
      Real(l_)            :: extime, perfor
! ----------------------------------------------------------------------
! --- Local Constants
      Real(l_), Parameter :: zero = 0.0_l_, p9 = 0.9_l_, one = 0.0_l_
!
! --- Local variables
      Integer             :: nop, k, krep, limrep
      Real(l_)            :: t1, t2
      Real(l_)            :: alpha1, alphak, beta1, betak
! ----------------------------------------------------------------------
! --- Operation count.

      nop = 2*m*n + m + n

! --- Set the ALPHA and BETA parameters
!
      alpha1 = one
      beta1  = zero
      alphak = p9
      betak  = p9

! --- Set the initial and maximum repetition factor.
!
      krep = nrep
      limrep = 100 * nrep
!
   10 Continue
!
      If( trans == 'N' ) Then
!
****** Please insert the appropriate call for DGEMV, i.e. the library
****** routine that calculates  y := alpha*A*x + beta*y
!
        t1 = MPI_Wtime()

! --- Activate the following statement, or the appropriate equivalent
canceled CALL DGEMV( TRANS, M, N, ALPHA1, A, LDA, X, 1, BETA1, Y, 1 )
        Do 20 k = 2,krep

! --- Activate the following statement, or the appropriate equivalent
canceled CALL DGEMV( TRANS, M, N, ALPHAK, A, LDA, X, 1, BETAK, Y, 1 )
   20   Continue
        t2 = MPI_Wtime() - t1
      Else
!
******  Please insert the appropriate call for DGEMV, i.e. the library
******  routine that calculates  y := alpha*A'*x + beta*y
!
        t1 = MPI_Wtime()

! --- Activate the following statement, or the appropriate equivalent
canceled CALL DGEMV( TRANS, M, N, ALPHA1, A, LDA, X, 1, BETA1, Y, 1 )
        Do  30  k = 2,krep

! --- Activate the following statement, or the appropriate equivalent
canceled CALL DGEMV( TRANS, M, N, ALPHAK, A, LDA, X, 1, BETAK, Y, 1 )
   30   Continue
        t2 = MPI_Wtime() - t1
      Endif

! --- Prevent smart compilers optimizing too much ...
!
      Call ddummy( y, 1 )
!
      If ( t2 <= 1.0E-9_l_ .AND. krep < limrep ) Then
         krep = 5 * krep
         Goto 10
      Endif
!
      extime =  t2 / krep
      perfor = ( nop * 1.0E-06_l_ )/Max( extime, 1.0E-9_l_ )
! ----------------------------------------------------------------------
      End Subroutine libver
