      Subroutine bsaddr
! ----------------------------------------------------------------------
! --- Routine 'bsaddr' calculates the offsets that occur when local
!     data must be copied into a global one that combines all local
!     data. As the sizes of the local arrays need not be the same,
!     offsets cannot be generated with local knowledge only.
!
! --- Input:  - Integer nodes              (via Module dist_module) 
!             - Integer sizes(0:maxnod-1)  (via Module dist_module)
! --- Output: - Integer offset(0:maxnod-1) (via Module dist_module)
! ----------------------------------------------------------------------
      Use        dist_module

      Integer :: i
! ----------------------------------------------------------------------
      offset(0) = 0
      Do i = 1, nodes - 1
         offset(i) = offset(i-1) + sizes(i-1)
      End Do
! ----------------------------------------------------------------------
      End Subroutine bsaddr
