      Subroutine gtrans( ar, ai, atr, ati, n1, n2, size1, size2, time )
! ----------------------------------------------------------------------
! --- 'gtrans' does a global transpose of array 'a' and puts it in 
!     array 'at'.
! ----------------------------------------------------------------------
      Use         numerics
      Use         mpi_module ! Contains # of proc.s & proc. no.s
      Implicit    None

      Integer  :: n1, n2, size1, size2
      Real(l_) :: ar(n1,size2),  ai(n1,size2),
     &            atr(n2,size1), ati(n2,size1)
      Real(l_) :: time

      Real(l_) :: wrkr(size2,n1), wrki(size2,n1)
      Real(l_) :: ltime
      Integer  :: scnts(0:nodes-1), sdpls(0:nodes-1),
     &            rcnts(0:nodes-1), rdpls(0:nodes-1)
! ----------------------------------------------------------------------
! --- Do local transposition.

      Call sizoff( n1, n2 )
      Call ltrans( n1, sizes(me,2), ar, ai, atr, ati )
      If ( nodes == 1 ) Return
! ----------------------------------------------------------------------
! --- Determine sizes and displacements of data to be sent.

      Call cntdpls( scnts, sdpls, rcnts, rdpls )
! ----------------------------------------------------------------------
! --- Distribute appropriate blocks over the processors.

      ltime = MPI_Wtime()
      Call MPI_AlltoAllv( atr, scnts, sdpls, rtyp,
     &                   wrkr, rcnts, rdpls, rtyp,
     &                   comm, ierr )
      Call MPI_AlltoAllv( ati, scnts, sdpls, rtyp,
     &                   wrki, rcnts, rdpls, rtyp,
     &                   comm, ierr )
      time = time + MPI_Wtime() - ltime
! ----------------------------------------------------------------------
! --- Do block transposition of the communicated data.

      Call btrans( sizes(me,1), n2, wrkr, wrki, atr, ati )
! ----------------------------------------------------------------------
      End Subroutine gtrans           
