      Subroutine btrans ( n1, n2, ar, ai, tr, ti )
! -------------------------------------------------------------
! --- 'btrans' performs a blockwise local transposition. Input
!     array is 'a[r|i]', output array is 't[r|i]'
! -------------------------------------------------------------
      Use         numerics
      Use         mpi_module ! Contains #procs and sizes.
      Implicit    None

      Integer  :: n1, n2
      Real(l_) :: ar(n1*n2), ai(n1*n2), tr(n1*n2), ti(n1*n2)

      Integer  :: m1, m2, b1, b2, i, j, k, l
! -------------------------------------------------------------
      m2 = sizes(me,1) ! <-- From mpi_module.
      b1 = 0; l = 1
      Do k = 0, nodes - 1
         m1 = sizes(k,2)
         b2 = 0
         Do i = 1, m2
            Do j = 1, m1
               tr(j+b1+b2) = ar(l)
               ti(j+b1+b2) = ai(l)
               l = l + 1
            End Do
            b2 = b2 + n2
         End Do
         b1 = b1 + m1
      End Do
! -------------------------------------------------------------
      End Subroutine btrans
