      Subroutine nflops( m, mfli, mflt )
! ----------------------------------------------------------------------
! --- nflops calculates the number of flops for the complex-to-
!     complex Radix-4 FFT of length 2**M.
!     M should be >= 2.
! --- In the initialisation part it is assumed that the evaluation
!     of a Sine or Cosine function takes 10 flops.
! ----------------------------------------------------------------------
      Integer    :: m
      Integer(8) :: mfli, mflt

      Integer(8) :: mfl2, mfl3, mdiv, mmod, m2, n, n12, n14, n24, n4
! ----------------------------------------------------------------------
! --- Test input parameter.

      If ( m < 4 ) Then
         Print *, ' *** Error in routine Nflops: m < 4 : m = ', m
         Return
      End If
! ----------------------------------------------------------------------
! --- Initialisation part:

      m2   = ( m + 1 )/2
      mfli = 21*( 4**m2 - 1 )/3 + m2
! ----------------------------------------------------------------------
! --- Transform part:

      n = 2**m
      If ( n < 64 ) Then
         If ( n == 16 ) Then
            mflt = 264
         Else If ( n == 32 ) Then
            mflt = 644
         End If
      Else
         n4   = n/4
         mfl2 = 54*n4 + 48
         mmod = Mod( m, 4 )
         mdiv = ( m - 1 )/4
         n12  = 23*n4
         n14  = 48*n4
         n24  = n14 + n14
         mfl3 = ( mdiv - 1 )*n24
         Select Case( mmod )
         Case( 0 )
            mfl3 = mfl3 + n24
         Case( 1 )
            mfl3 = mfl3 + n12
         Case( 2 )
            mfl3 = mfl3 + n14
         Case( 3 )
            mfl3 = mfl3 + n14 + n12
         End Select
         mflt = mfl2 + mfl3
      End If
! ----------------------------------------------------------------------
      End Subroutine nflops
