#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "fundefs.h"
#define  Max( a, b ) ( (a > b ) ? a : b )

int main()
// ---------------------------------------------------------------------
// -- 'mod2i' tests the performance of sorting of an a array of integers
//     and doubles.
// ---------------------------------------------------------------------
{
   int    *idata, *src;
   double *ddata;
   double corr, speed1, speed2, time1, time2;
   int    irep, n, nops, nrep;
   int    nbd, nbi;
   int    ok1, ok2;
   FILE   *inl;
// ---------------------------------------------------------------------
   state( "mod2i" );
   prthead();
   inl = fopen( "mod2i.in", "r" );
   while( ( fscanf( inl, "%d%d\n", &n, &nrep ) != EOF ) ) {
      nbd = n*sizeof ( double );
      nbi = n*sizeof ( int );
      src   = calloc( n, sizeof( int ) );
      idata = calloc( n, sizeof( int ) );
      ddata = calloc( n, sizeof( double ) );
      nops  = n*(int)log2( (double)n ); 
      ranint( 1, n, n, src );
      time1 = cclock();
      for( irep = 1; irep <= nrep; irep++ ) {
         memcpy( idata, src, nbi );
         iqsort( 0, n-1, idata );
      }
      time1 = cclock() - time1;
      time2 = cclock();
      for( irep = 1; irep <= nrep; irep++ ) {
         cp_arrd( n, src, ddata );
         dqsort( 0, n-1, ddata );
      } 
      time2 = cclock() - time2;
      ok1 = icheck( n, idata );
      ok2 = dcheck( n, ddata );
      corr = cclock();
      for( irep = 1; irep <= nrep; irep++ ) {
         memcpy( idata, src, nbi );
      }
      corr = cclock() - corr;
      time1 = ( time1 - corr )/nrep;
      corr = cclock();
      for( irep = 1; irep <= nrep; irep++ ) {
         cp_arrd( n, src, ddata );
      }
      corr = cclock() - corr;
      time2 = ( time2 - corr )/nrep;
      speed1 = 1.0e-6*(double)nops/Max( time1, 1.0e-9 );
      speed2 = 1.0e-6*(double)nops/Max( time2, 1.0e-9 );
      prtspeed( n, time1, speed1, ok1, time2, speed2, ok2 );
      free( src ); free( idata ); free( ddata );
   }
   printf( "---------------------------------------------------" );
   printf( "------------------------\nRan OK\n" );
}
