#include <stdio.h>
#include <stdlib.h>
#include "fundefs.h"

int main()
{ 
   int      nsize;
   int      ok;
   double   *a;
   double   mops, time;
   FILE     *inl;
// ------------------------------------------------------------------------
   state( "mod2h" );
   prthead();
   inl = fopen( "mod2h.in", "r" );
   while( ( fscanf( inl, "%d\n", &nsize ) != EOF ) ) {
      a = malloc( nsize*sizeof( double ) );
      time = cclock();
      ranfil( a, nsize );
      time = cclock() - time;
      ok   = check( a, nsize );
      mops = 1.0e-6*(double)nsize/time;
      prtspeed( nsize, time, mops, ok ); 
      free( a );
   }
   printf( "----------------------------------------\n" );
   printf( "Ran OK\n" );
}
