#include <stdio.h>
#include <math.h>

int check( double a[], double b[], int n, double err )
//----------------------------------------------------------------------
//--- 'check' checks the errors made in the transformation of a
//    complex-to-complex FFT. 'check' is specific for the input
//    of this program.
//    The Real part is a full cycle of a cosine signal and the
//    Imaginary part is 0.0 everywhere.
//    The resulting transform should show values of N/2 for
//    A[1] and A[N-1]. All other entries should be 0.0.
//    This is checked below with a Floating-Point error
//    margin of ERR = ( 10.0*N Log N )*EPS, with EPS the
//    Floating-Point spacing of the machine tested.
//--- The Real part of A is stored in A[0], ..., A[N-1];
//    The Imaginary part in B[0], ..., B[N-1].
//----------------------------------------------------------------------
{
   int i, ok = 0;
//----------------------------------------------------------------------
   if ( a[0] > err ) {
      printf( "First Real element,  n = %8d%8d %13.5g%13.5g\n", n, 0,
               a[0], err );
      return( ++ok );
   }
   for( i = 3; i < n - 1; i++ ) {
      if ( a[i-1] > err ) {
         printf( "Real element,        n = %8d%8d %13.5g%13.5g\n", n, i-1,
                  a[i-1], err );
         return( ++ok );
      }
   }
   if ( fabs( a[1] - (double)(n/2) ) > err ) {
      printf( "Second Real element, n = %8d%8d %13.5g%13.5g\n", n, 2,
               a[1], (double)(n/2) );
      return( ++ok );
   }
   if ( fabs( a[n-1] - (double)(n/2) ) > err ) {
      printf( "N-th Real element, n = %8d%8d %13.5g%13.5g\n", n, n,
               a[n-1], (double)(n/2) );
      return( ++ok );
   }
   for( i = 0; i < n-1; i++ ) {
      if ( b[i] > err ) {
         printf( "Imaginary element,   n = %8d%8d %13.5g%13.5g\n", n, i,
                  b[i], err );
         return( ++ok );
      }
   }
   return ( ok );
}     
