#include "fundefs.h"

void sym7icg0( int n1, int n2, int n3, int m, double **a, double *rmr,
               double *q, double *x, double *y, double *gamma )
/*---------------------------------------------------------------------
  --- ILU0 preconditioner. q and gamma are not used in this routine as
      these parameters are only relevant for polynomial
      preconditioning.
  ---------------------------------------------------------------------*/
{
   extern long flops;
   int    i, ibw, n12, ntot;
// ---------------------------------------------------------------------
// -- Forward solve: Corner.

   y[1] = x[1];
// ---------------------------------------------------------------------
// -- Foward solve: Rest.

   n12  = n1*n2;
   ntot = n12*n3;
   for( i = 1; i < n1; ++i ) {
      y[i] = x[i] - a[i-1][1]*y[i-1];
   }
   for( i = n1; i < n12; ++i ) {
      y[i] = x[i] - a[i-1][1]*y[i-1] - a[i-n1][2]*y[i-n1];
   }
   for( i = n12; i < ntot; ++i ) {
      y[i] = x[i] - a[i-1][1]*y[i-1] - a[i-n1][2]*y[i-n1] -
             a[i-n12][3]*y[i-n12];
   }
// ---------------------------------------------------------------------
// -- Computation of (r,Mr) where M is the preconditioner

   *rmr = nrm2( ntot, y );
// ---------------------------------------------------------------------
// -- Back solve:

   ibw = ntot - 2;
   for( i = 1; i < n1; ++i ) {
      y[ibw] -= a[ibw][1]*y[ibw+1];
      ibw--;
   }
   for( i = n1; i < n12; ++i ) {
      y[ibw] -= ( a[ibw][1]*y[ibw+1] + a[ibw][2]*y[ibw+n1] );
      ibw--;
   }
   for( i = n12; i < ntot; ++i ) {
      y[ibw] -= ( a[ibw][1]*y[ibw+1] + a[ibw][2]*y[ibw+n1] +
                  a[ibw][3]*y[ibw+n12] );
      ibw--;
   }

   flops += 5*( n1 - 1 ) + 9*( n12 - n1 ) + 13*( ntot -n12 ) + 2*ntot;
} // -- End of sym7icg0
