#include <stdio.h>
#include <stdlib.h>
#include "fundefs.h"

long int flops;

int main()
{ 
   int      n, ncols, nrows, nelmts;
   extern long int flops;
   int const m = 1, maxit = 50;
   int      i, nrep1;
   int      *indx, *rowp;
   double   gamma[m+1], *matvals, *b, *q, *x;
   double   frac, mflops, time;
   double   tol = 1.0e-10;
   double   resnrm;
   FILE     *inl;
// ------------------------------------------------------------------------
   state( "mod2ci" );
// ------------------------------------------------------------------------
// --- Do cases with Gmres solver.

   printf( "Program mod2ci: Sparse iterative solver test\n" );
   printf( "Non-symmetric, CRS: RGMRES with polyn. preconditioner.\n" );
   printf( "-------------------------------------------------------" );
   printf( "-----------\n" );
   prthead();
   inl = fopen( "mod2ci.in", "r" );
   while( ( fscanf( inl, "%d%d%d%d\n", &ncols, &nrows, &nelmts, &nrep1 )
          != EOF ) ) {
      n       = nrows*ncols;
      indx    = calloc( nelmts, sizeof( int ) );
      rowp    = calloc( nrows+1, sizeof ( int ) );
      matvals = calloc( nelmts, sizeof ( double ) );
      b       = calloc( ncols, sizeof ( double ) );
      q       = calloc( nrows, sizeof ( double ) );
      x       = calloc( nrows, sizeof ( double ) );
      gendat( nrows, nelmts, indx, rowp, matvals, b );
      pcoefs( m, gamma );
      setval( nrows, q, 1.0 );
      flops = 0;
      time = cclock();
      for( i = 1; i <= nrep1; ++i ) {
         setval( nrows, x, 0.0 );
         rgmres( nrows, nelmts, m, indx, rowp, matvals, q, x, b, gamma,
                 maxit, tol, &resnrm );
      }
      time = cclock() - time;
      mflops = 1.0e-6*(double)flops/time;
      time   = time/(double)nrep1;
      frac   = 100.0*(double)nelmts/(double)(ncols*nrows);
      prtspeed( ncols, nrows, frac, time, mflops, resnrm ); 
      free( indx ); free( rowp ); free( matvals ); free( b );
      free( q ); free( x );
   }
   printf( "-------------------------------------------------------" );
   printf( "-----------\nRan OK\n\n\n" );
   printf( "-------------------------------------------------------" );
   printf( "-----------\n" );
   printf( "Program mod2ci: Sparse iterative solver test\n" );
   printf( "Non-symmetric, CRS: TFQMR with polyn. preconditioner.\n" );
   printf( "-------------------------------------------------------" );
   printf( "-----------\n" );
   prthead();
   rewind( inl );
   while( ( fscanf( inl, "%d%d%d%d\n", &ncols, &nrows, &nelmts, &nrep1 )
          != EOF ) ) {
      n       = nrows*ncols;
      indx    = calloc( nelmts, sizeof( int ) );
      rowp    = calloc( nrows+1, sizeof ( int ) );
      matvals = calloc( nelmts, sizeof ( double ) );
      b       = calloc( ncols, sizeof ( double ) );
      q       = calloc( nrows, sizeof ( double ) );
      x       = calloc( nrows, sizeof ( double ) );
      gendat( nrows, nelmts, indx, rowp, matvals, b );
      pcoefs( m, gamma );
      setval( nrows, q, 1.0 );
      flops = 0;
      time = cclock();
      for( i = 1; i <= nrep1; ++i ) {
         setval( nrows, x, 0.0 );
         tfqmr( nrows, nelmts, m, indx, rowp, matvals, q, x, b, gamma,
                 maxit, tol, &resnrm );
      }
      time = cclock() - time;
      mflops = 1.0e-6*(double)flops/time;
      time   = time/(double)nrep1;
      frac   = 100.0*(double)nelmts/(double)(ncols*nrows);
      prtspeed( ncols, nrows, frac, time, mflops, resnrm ); 
      free( indx ); free( rowp ); free( matvals ); free( b );
      free( q ); free( x );
   }
   printf( "-------------------------------------------------------" );
   printf( "-----------\nRan OK\n" );
}
