double dran0( int *x1, int *x2 )
// ---------------------------------------------------------------------
// -- Linear congruence pseudo RNG with choices for A, C, and M as
//    found in D. Knuth in "Semi-numerical algorithms".
// ---------------------------------------------------------------------
{
   int const    m1  = 259200, a1 = 7141, c1 = 54773,
                m2  = 134456, a2 = 8121, c2 = 28411;
   double const rm1 = 1.0/m1, rm2 = 1.0/m2;
// ---------------------------------------------------------------------
   *x1 = ( a1*(*x1) + c1 )%m1;
   *x2 = ( a2*(*x2) + c2 )%m2;
   return ( ( (double)(*x1) + (double)(*x2)*rm2 )*rm1 );
}
