int dscal( int n, double da, double *dx, int incx )
{
// ---------------------------------------------------------------------
// -- Purpose: Scales vector 'dx' by constant 'da' for 'n' elements
//    spaced by 'incx' elements ('n', 'incx' > 0).
// ---------------------------------------------------------------------
   int i, m, nincx;

// -- Test parameters.
   if ( n <= 0 || incx <= 0 ) return 0;
   if ( incx == 1 ) {                       // -- Increment equal 1.
      m = n%4;
      for( i = 0; i < m; i++ ) {
         dx[i] = da*dx[i];
      }
      for( i = m; i < n; i += 4 ) {
         dx[i  ] = da*dx[i  ];
         dx[i+1] = da*dx[i+1];
         dx[i+2] = da*dx[i+2];
         dx[i+3] = da*dx[i+3];
      }
   }
   else {
      nincx = n*incx;
      for( i = 0; i < nincx; i += incx ) {  // -- Increment /= 1.
         dx[i] = da*dx[i];
      }
   }
   return 0;
} // -- dscal
       
