#include <stdio.h>
#include <stdlib.h>
#include "fundefs.h"

int main()
{ 
   int      lda, m, l, n;
   int      ok, nrep;
   int      cbt;
   int      i;
   double   **a, **b, **c;
   double   corr, nops, time;
   FILE     *inl;
// ------------------------------------------------------------------------
   state( "mod2a" );
   prthead();
   inl = fopen( "mod2am.in", "r" );
   while( ( fscanf( inl, "%d%d%d%d\n", &m, &l, &n, &nrep ) != EOF ) ){
      lda = l + 1;
      cbt = n*m*sizeof( double );
      a = makmat( m, lda );
      b = makmat( l, n );
      c = makmat( m, n );
      gendat( lda, m, l, n, a, b );
      time = cclock();
      for( i = 0; i < nrep; i++ ){
         clr_arr( n, m, c );
         mxm( lda, m, l, n, a, b, c ); 
      }
      time = cclock() - time;
      ok   = check( m, l, n, c );
      corr = cclock();
      for( i = 0; i < nrep; i++ ){
         clr_arr( n, m, c );
      }
      corr = cclock() - corr;
      time = ( time - corr )/nrep;
      nops  = 2*(double)m*(double)l*(double)n;
      prtspeed( m, l, n, time, ok, nops );
      delmat( m, a );
      delmat( l, b );
      delmat( m, c );
   }
   printf( "----------------------------------------------------\n" );
   printf( "Ran OK\n" );
}
