#include <stdio.h>
#include <math.h>
#include "fundefs.h"

void summ( char *cm, int j, double r6, double r7, double a, double b,
           double c, double d, double x1, double y1 )
// ---------------------------------------------------------------------
// -- Function 'ssum' prints a summary of test results.
// ---------------------------------------------------------------------
{
   int           i;
   int           prall = 0;
   double        w6, w7, decdig;
   extern int    izr, ja[50];
   extern char   *cha[50];
   extern double ra[50][8];
   extern int    ibeta, irnd, it, maxexp, minexp, n;
   extern double xmax, xmin;
// ---------------------------------------------------------------------
   if ( j == 0 ) {
      izr = 0;
      return;
   }
   if ( j > 0 ) {
      izr++;
      cha[izr-1]   = cm;
      ja[izr-1]    = j;
      ra[izr-1][0] = r6;
      ra[izr-1][1] = r7;
      ra[izr-1][2] = x1;
      ra[izr-1][3] = a;
      ra[izr-1][4] = b;
      if ( cm == "X**Y" ) {
         ra[izr-1][5] = c;
         ra[izr-1][6] = d;
         ra[izr-1][7] = y1;
      }
      return;
   }
   if ( j < 0 ) {
      decdig = (double)it*log10( (double)ibeta );
      if ( j == -1 ) {
         printf( "\n\n Accuracy elementary functions (Scalar)" );
         printf( "                       Summary (Decimal)\n" );
         printf( " -------------------------------------" );
         printf( "                       -----------------\n" );
      }
      if ( j == -2 ) {
         printf( "\n\n Accuracy elementary functions (Scalar)" );
         printf( "                    Summary (Base Ibeta)\n" );
         printf( " -------------------------------------" );
         printf( "                       -----------------\n" );
      }
      printf( " ibeta = %3d  minexp = %6d   xmin      = %16.7g\n",
                ibeta,       minexp,        xmin         );
      printf( " it    = %3d  maxexp = %6d   xmax      = %16.7g\n",
                it,          maxexp,        xmax         );
      printf( " irnd  = %3d                               \n",
                irnd );
      printf( " n = %6d                      Dec.Digits = %7.3f\n",
                   n,                           decdig       );
      if ( j == -1 ) {
         printf( "                                            " );
         printf( "      Loss of decimal digits\n" );
         printf( " Function test             Interval              RMS" );
         printf( "     Max       Max at x =\n" );
      }
      if ( j == -2 ) {
         printf( "                                            " );
         printf( "      Loss of base-IBETA digits\n" );
         printf( " Function test             Interval              RMS" );
         printf( "     Max       Max at x =\n" );
      }
      for( i = 0; i < izr; ++i ) {
         if ( ja[i] == 1 ) printf( "\n" );
         w6 = 0.0;
         w7 = 0.0;
         if ( ra[i][0] != 0.0 ) w6 = max(log10(fabs( ra[i][0]) ) + decdig, w6);
         if ( ra[i][1] != 0.0 ) w7 = max(log10(fabs( ra[i][1]) ) + decdig, w7);
         if ( j == -2 ) {
            w6 = w6/log10( (double)ibeta );
            w7 = w7/log10( (double)ibeta );
         }
         printf( " %s%d  (%14.7e,%14.7e)%8.2f%8.2f  %14.7e\n", cha[i], ja[i],
                 ra[i][3], ra[i][4], w7, w6, ra[i][2] );
         if ( cha[i] == "X**Y    " ) {
            printf( "              (%14.7e,%14.7e)                y = %14.7e\n",
                    ra[i][5], ra[i][6], ra[i][7] );
         }
      }
      return;
   }
} // -- End of summ
