#include <math.h>
#include "fundefs.h"

void stanh( void )
// ---------------------------------------------------------------------
// -- Function to test Tanh(x)
// ---------------------------------------------------------------------
{
   int    i, j;
   double a, ait, albeta, b, beta, c, d, del, half, one, r6, r7, w, x,
          xl, xn, x1, y, z, zero, zz, dummy;
   char   *cm[2] = { "Tanh(x)   ", "Tanh(x)   " };
   extern int    ibeta, irnd, it, n;
   extern double xmax, xmin;
// ---------------------------------------------------------------------
   beta   = (double)ibeta;
   albeta = log( beta );
   ait    = (double) it;
   zero   = 0.0;
   half   = 0.5;
   one    = 1.0;
   a      = 0.125;
   b      = log( 3.0 )*half;
   c      = 1.24353001771596208054647275805892707e-1;
   d      = log( 2.0 ) + ( ait + one )*log( beta )*half;
   xn     = (double)n;
// ---------------------------------------------------------------------
// -- Random argument accuracy tests.
// ---------------------------------------------------------------------
   for( j = 1; j <= 2; ++j ) {
      x1 = zero;
      r6 = zero;
      r7 = zero;
      del = ( b - a )/xn;
      xl = a;
      for( i = 1; i <= n; ++i ) {
         x  = del*rand64() + xl;
         z  = tanh( x );
         y  = x - 0.125;
         zz = tanh( y );
         zz = ( zz + c )/( one + c*zz );
         w  = one;
         if ( z != zero )  w = ( z - zz )/z;
         w  = fabs( w ); 
         if ( w > r6 ) {
            r6 = w;
            x1 = x;
         }
         r7 = r7 + w*w;
         xl = xl + del;
      }
      r7 = sqrt( r7/xn );
      summ( cm[j-1], j, r6, r7, a, b, dummy, dummy, x1, dummy );
      a = b + a;
      b = d;
   }
} // -- End of stanh
