#include <math.h>
#include <float.h>

void ssqrt( void )
// ---------------------------------------------------------------------
// -- Function to test square root.
// ---------------------------------------------------------------------
{
   int    i, j;
   double a, ait, albeta, b, beta, c, one, r6, r7, sqbeta, w, x, xn, x1, y,
          z, zero, dummy;
   char   *cm[2] = { "Sqrt(xsq) ", "Sqrt(xsq) " };
   extern int    ibeta, irnd, it, n;
   extern double xmax, xmin;
// ---------------------------------------------------------------------
   beta   = (double)ibeta;
   sqbeta = sqrt( beta );
   albeta = log( beta );
   ait    = (double)it;
   one    = 1.0;
   zero   = 0.0;
   a      = one/sqbeta;
   b      = one;
   xn     = (double)n;
// ---------------------------------------------------------------------
// -- Random argument accuracy tests.
// ---------------------------------------------------------------------
   for( j = 1; j <= 2; ++j ) {
      c  = log( b/a );
      x1 = zero; 
      r6 = zero; 
      r7 = zero; 
      for( i = 1; i <= n; ++i ) {
         x = a*randl( c );
         y = x*x;
         z = sqrt( y );
         w = ( z - x )/x;
         w = fabs( w );
         if ( w > r6 ) {
            r6 = w;
            x1 = x;
         }
         r7 += w*w;
      }
      r7 = sqrt( r7/xn );
      summ( cm[j-1], j, r6, r7, a, b, dummy, dummy, x1, dummy ); 
      a = one;
      b = sqbeta;
   }
} // -- End of ssqrt
