#include <math.h>
#include "fundefs.h"

void ssinh( void )
// ---------------------------------------------------------------------
// -- Function to test Sinh/Cosh(x)
// ---------------------------------------------------------------------
{
   int    i, ii, i2, j, nit;
   double a, aind, ait, albeta, alxmax, b, beta, c, c0, del, den, epslon,
          five, one, r6, r7, three, w, x, xl, xn, x1, xsq, y, z, zero,
          zz, dummy;
   char   *cm[4] = { "Sinh(x)   ", "Cosh(x)   ", "Sinh(x)   ", "Cosh(x)   " };
   extern int    ibeta, irnd, it, n;
   extern double xmax, xmin;
// ---------------------------------------------------------------------
   beta   = (double)ibeta;
   albeta = log( beta );
   alxmax = log( xmax ) - 0.5;
   ait    = (double) it;
   zero   = 0.0;
   one    = 1.0;
   three  = 3.0;
   five   = 5.0;
   a      = zero;
   b      = 0.5;
   c      = ( ait + one )*0.35;
   if ( ibeta == 10 ) c = c*three;
   c0     = five/16.0 + 1.15271368319426997874886766130751616e-2;
   i2     = 2;
   epslon = pow( beta, ( 1 - it ) )/2.0;
   nit    = 2 - ( (int)( log( epslon )*three ) )/20;
   aind   = (double)( nit + nit + 1 );
   xn     = (double)n;
// ---------------------------------------------------------------------
// -- Random argument accuracy tests.
// ---------------------------------------------------------------------
   for( j = 1; j <= 4; ++j ) {
      if ( j == 2 ) {
         aind = aind - one;
         i2   = 1;
      }
      x1 = zero;
      r6 = zero;
      r7 = zero;
      del = ( b - a )/xn;
      xl = a;
      for( i = 1; i <= n; ++i ) {
         x  = del*rand64() + xl;
         if ( j > 2 ) goto L20;
         xsq = x*x;
         zz  = one;
         den = aind;
         for( ii = i2; ii <= nit; ++ii ) {
            w   = zz*xsq/( den*( den - one ) );
            zz  = w + one;
            den = den - 2.0; 
         }
         if ( j == 2 ) goto L10;
         w  = x*xsq*zz/6.0;
         zz = x + w;
         z  = sinh( x );
         if ( irnd != 0 ) goto L40; 
         w  = ( x - zz ) + w;
         zz = zz + ( w + w );
         goto L40;
L10:     z  = cosh( x );
         if ( irnd != 0 ) goto L40;
         w  = ( one - zz ) + w;
         zz = zz + ( w + w );
         goto L40;
L20:     y = x;
         x = y - one;
         w = x - one;
         if ( j == 4 ) goto L30;
         z  = sinh( x );
         zz = ( sinh( y ) + sinh( w ) )*c0;
         goto L40;
L30:     z  = cosh( x );
         zz = ( cosh( y ) + cosh( w ) )*c0;
L40:     w  = one;
         if ( z != zero ) w = ( z - zz )/z;
         w  = fabs( w );
         if ( w > r6 ) {
            r6 = w;
            x1 = x;
         }
         r7 = r7 + w*w;
         xl = xl + del;
      }
      r7 = sqrt( r7/xn );
      i  = ( j/2 )*2;
      summ( cm[j-1], j, r6, r7, a, b, dummy, dummy, x1, dummy );
      if ( j == 2 ) {
         a = three;
         b = alxmax;
      }
   }
} // -- End of ssinh 
