#include <math.h>
#include "fundefs.h"

void ssin( void )
// ---------------------------------------------------------------------
// -- Function to test Sin/Cos(x)
// ---------------------------------------------------------------------
{
   int    i, j;
   double a, ait, albeta, b, beta, c, del, one, r6, r7, three, w, x, xl,
          xn, x1, y, z, zero, zz, dummy;
   char   *cm[3] = { "Sin(x)    ", "Sin(x)    ", "Cos(x)    " };
   extern int    ibeta, irnd, it, n;
   extern double xmax, xmin;
// ---------------------------------------------------------------------
   beta    = (double)ibeta;
   albeta  = log( beta );
   ait     = (double) it;
   one     = 1.0;
   zero    = 0.0;
   three   = 3.0;
   a       = zero;
   b       = 1.570796327;
   c       = b;
   xn      = (double)n;
// ---------------------------------------------------------------------
// -- Random argument accuracy tests.
// ---------------------------------------------------------------------
   for( j = 1; j <= 3; ++j ) {
      x1 = zero;
      r6 = zero;
      r7 = zero;
      del = ( b - a )/xn;
      xl = a;
      for( i = 1; i <= n; ++i ) {
         x  = del*rand64() + xl;
         y  = x/three;
         y  = ( x + y ) - x;
         x  = three*y;
         if ( j == 3 ) goto L10;
         z  = sin(x);
         zz = sin(y);
         w  = one;
         if ( z != zero ) w = ( z - zz*( three - 4.0*zz*zz ) )/z;
         goto L20;
L10:     z  = cos( x );
         zz = cos( y );
         w  = one;
         if ( z != zero ) w = ( z + zz*( three - 4.0*zz*zz ) )/z;
L20:     w  = fabs( w );
         if ( w > r6 ) {
            r6 = w;
            x1 = x;
         }
         r7 = r7 + w*w;
         xl = xl + del;
      }
      r7 = sqrt( r7/xn );
      summ( cm[j-1], j, r6, r7, a, b, dummy, dummy, x1, dummy );
      a = 18.84955592;
      if ( j == 2 ) a = b + c;
      b = a + c;
   }
} // -- End of ssin
