#include <math.h>
#include "fundefs.h"

void satan( void )
// ---------------------------------------------------------------------
// -- Function to test arctan/arccot(x)
// ---------------------------------------------------------------------
{
   int    i, ii, j;
   double a, ait, albeta, b, beta, del, em, half, ob32, one, r6, r7, sum,
          two, w, x, xl, xn, xsq, x1, y, z, zero, zz, dummy;
   char   *cm[8] = { "Atan(x)   ", "Atan(x)   ", "Atan(x)   ", "Atan(x)   " };
   extern int ibeta, irnd, it, n;
// ---------------------------------------------------------------------
      beta    = (double)ibeta;
      albeta  = log( beta );
      ait     = (double)it;
      one     = 1.0;
      half    = 0.5;
      two     = 2.0;
      zero    = 0.0;
      a       = -0.0625;
      b       = -a;
      ob32    = b*half;
      xn      = (double)n;
// ---------------------------------------------------------------------
// -- Random argument accuracy tests.
// ---------------------------------------------------------------------
      for( j = 1; j <= 4; ++j ) {
         x1 = zero;
         r6 = zero;
         r7 = zero;
         del = (b - a)/xn;
         xl = a;
         for( i = 1; i <= n; ++i ) {
            x = del*rand64() + xl;
            if ( j == 2 ) x = ( ( 1.0 + x*a )- one )*16.0;
            z = atan( x );
            if ( j != 1 ) goto L10;
            xsq = x*x;
            em = 29.0;
            sum = xsq/em;
            for( ii = 1; ii <= 13; ++ii ) {
               em = em - two;
               sum = ( one/em - sum )*xsq;
            }
            sum = -x*sum;
            zz  = x + sum;
            sum = ( x - zz ) + sum;
            if ( irnd == 0 ) zz = zz + ( sum + sum );
            goto L30;
L10:        if ( j != 2 ) goto L20;
            y = x - 0.0625;
            y = y/( one + x*a );
            zz = (atan( y ) - 8.11900040426515260208870144948863937e-5) + ob32;
            zz = zz + ob32;
            goto L30;
L20:        z  = z + z;
            y  = x/( ( half + x*half )*( (half - x) + half ) );
            zz = atan( y );
L30:        w  = one;
            if ( z != zero ) w = ( z - zz )/z;
            w  = fabs( w );
            if ( w > r6 ) {
               r6 = w;
               x1 = x;
            }
            r7 = r7 + w*w;
            x1 = x1 + del;
        }
        r7 = sqrt( r7/xn );
        summ( cm[j-1], j, r6, r7, a, b, dummy, dummy, x1, dummy );
        a = b;
        if ( j == 1 ) b = two - sqrt( 3.0 );
        if ( j == 2 ) b = sqrt( two ) - one;
        if ( j == 3 ) b = one;
    }
} // -- End of satan
