#include <math.h>
#include "fundefs.h"
#include <stdio.h>

void sasin( void )
// ---------------------------------------------------------------------
// -- Function 'sasin' tests the accuracy of the arcsinus and arccosinus
//    functions.
// ---------------------------------------------------------------------
{
   int    i, i1, j, k, l, m;
   double a, ait, albeta, b, beta, c1, c2, del, half, r6, r7, s,
          sum, w, x, x1, xm, xn, xl, y, ysq, z, zero, zz, dummy;
   char *cm[5] = { "Asin(x)   ", "Acos(x)   ", "Asin(x)   ", "Acos(x)   ",
                   "Acos(x)   " };
   extern int ibeta, irnd, it, n;
// ---------------------------------------------------------------------
   beta   = (double)ibeta;
   albeta = log( beta );
   zero   = 0.0;
   half   = 0.5;
   ait    = (double)it;
   k      = (int)log10( pow( beta, it ) ) + 1;
   if ( ibeta == 10 ) {
      c1 = 1.57;
      c2 = 7.96326794896619231321691639751442099e-4;
   }
   else {
      c1 = 201.0/128.0;
      c2 = 4.83826794896619231321691639751442099e-4;
   }
   a  = -0.125;
   b  = -a;
   xn = (double)n; 
   l  = -1;
// ---------------------------------------------------------------------
// -- Random argument accuracy tests.
// ---------------------------------------------------------------------
   for( j = 1; j <= 5; ++j ) {
      l   = -l;
      x1  = zero;
      r6  = zero;
      r7  = zero;
      del = ( b - a )/xn;
      x1  = a;
      for( i = 1; i <= n; ++i ) {
         x = del*rand64() + x1;
         if ( j <= 2 ) goto L10;
         ysq = half - half*fabs( x );
         x   = ( half - ( ysq + ysq ) ) + half;
         if ( j == 5 ) x = -x;
         y   = sqrt( ysq );
         y   = y + y;
         goto L20;
L10:     y   = x;
         ysq = y*y;
L20:     sum = zero;
         xm  = (double)( k + k + 1 );
         if( l > 0 ) z = asin( x );
         if( l < 0 ) z = acos( x );
         for( m = 1; m <= k; ++m ) {
            sum = ysq*( sum + 1.0/xm );
            xm  = xm - 2.0;
            sum = sum*( xm/( xm + 1.0 ) );
         }
         sum = sum*y;
         if ( ( j != 1 ) && ( j != 4 ) ) goto L30;
         zz  = y + sum;
         sum = ( y - zz ) + sum;
         if ( irnd != 1 ) zz = zz + ( sum + sum );
         goto L40;
L30:     s   = c1 + c2;
         sum = ( ( c1 - s ) + c2 ) - sum;
         zz  = s + sum;
         sum = ( ( s - zz ) + sum ) -y;
         s   = zz;
         zz  = s + sum;
         sum = ( s - zz ) + sum;
         if ( irnd != 1 ) zz = zz + ( sum + sum ); 
L40:     w = 1.0;
         if ( z != zero ) w = ( z - zz )/z;
         w = fabs( w );
         if ( w > r6 ) {
            r6 = w;
            x1 = x;
         }
         r7 = r7 + w*w;
         x1 = x1 + del;
      }
      r7 = sqrt( r7/xn );
      summ( cm[j-1], j, r6, r7, a, b, dummy, dummy, x1, dummy );
      if ( j == 2 ) {
         a = 0.75;
         b = 1.0;
      }
      if ( j == 4 ) {
         b  = -a;
         a  = -1.0;
         c1 = c1 + c1;
         c2 = c2 + c2;
         l  = -l;
      }
   }
} // -- End of sasin 
