#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "fundefs.h"

#define Max( a, b ) ( ((a) > (b)) ? (a) : (b) )

int main()
{ 
   int      kernno, nbytes, nflops;
   int      length, nkern, nlens, repeat;
   int      i, j, k;
   char     kernel[51];
   double   *a, *b, *c;
   double   cycle, fpc, rtrans, speed, time;
   double   tbegin, tend;
   double   timelb = 1.0e-9;
   FILE     *inc, *ink, *inl;
// ---------------------------------------------------------------------
   state( "mod1b" );
   inl = fopen( "mod1b.in", "r" ); // Contains lengths & rep. factors.
   ink = fopen( "mod1b.krn", "r" );// Contains flops executed in kernel.
   inc = fopen( "mod1b.cyc", "r" );// Contains clock frequency of       
                                   // processor in Hz.
// --- Get clock frequency of processor.
   fscanf( inc, "%le", &cycle );

// --- Get number of kernels.
   nkern = 0;
   while( (fscanf( ink, "%51c%d%d%d", kernel, &nflops, &nbytes, &kernno ) )
           != EOF ) {
      nkern++;
   }
   rewind( ink );
   for( k = 1; k < nkern; k++ ) {
      gethead( ink, &nflops, &nbytes, &kernno );
      while( getlen( inl, &length, &repeat ) == 0 ) {
         time   = timer( kernno, length, repeat );
         time   = time/(double) repeat;
         if ( nflops == 0 ) nflops = 1;
         speed  = nflops*1.0e-6*( double) length/(time);
         fpc    = speed*1.0e6/cycle;
         rtrans = (double)nbytes*1.0e-9*(double)length/Max( time, timelb );
         printf( "%6d|%13.5g|%13.5g|%13.5g|%10.5f|%8d |\n", length, time,
                 speed, rtrans, fpc, repeat );
      }
      printf( "------------------------------------------------------" );
      printf( "-----------------\n\n" );
      rewind( inl );
   }
   printf( "Ran OK\n" );
}
