void synthr( int n, int m , double *a, double *w )
// ---------------------------------------------------------------------
// -- Routine 'synthr' does a 1-D Haar wavelet systhesis. 'a' is input,
//    'w' is output array.
// ---------------------------------------------------------------------
{
   int i, j, n1;
   int odd = 1;
// ---------------------------------------------------------------------
   n1 = 1;
   w[0] = a[0];
   for( i = 0; i < m; i++ ) {
      if ( odd ) {
         if ( n1 >= 4 ) {
            for( j = 0; j < n1; j+= 4 ) {
               w[j*2]   = a[j]   + a[j+n1];
               w[j*2+1] = a[j]   - a[j+n1];
               w[j*2+2] = a[j+1] + a[j+n1+1];
               w[j*2+3] = a[j+1] - a[j+n1+1];
               w[j*2+4] = a[j+2] + a[j+n1+2];
               w[j*2+5] = a[j+2] - a[j+n1+2];
               w[j*2+6] = a[j+3] + a[j+n1+3];
               w[j*2+7] = a[j+3] - a[j+n1+3];
            }
         }
         else if ( n1 >= 2 ) {
            for( j = 0; j < n1; j+= 2 ) {
               w[j*2]   = a[j]   + a[j+n1];
               w[j*2+1] = a[j]   - a[j+n1];
               w[j*2+2] = a[j+1] + a[j+n1+1];
               w[j*2+3] = a[j+1] - a[j+n1+1];
            }
         }
         else {
            for( j = 0; j < n1; j++ ) {
               w[j*2]   = a[j] + a[j+n1];
               w[j*2+1] = a[j] - a[j+n1];
            }
         }
      }
      else {
         if ( n1 >= 4 ) {
            for( j = 0; j < n1; j+= 4 ) {
               a[j*2]   = w[j]   + a[j+n1];
               a[j*2+1] = w[j]   - a[j+n1];
               a[j*2+2] = w[j+1] + a[j+n1+1];
               a[j*2+3] = w[j+1] - a[j+n1+1];
               a[j*2+4] = w[j+2] + a[j+n1+2];
               a[j*2+5] = w[j+2] - a[j+n1+2];
               a[j*2+6] = w[j+3] + a[j+n1+3];
               a[j*2+7] = w[j+3] - a[j+n1+3];
            }
         }
         else if ( n1 >= 2 ) {
            for( j = 0; j < n1; j+= 2 ) {
               a[j*2]   = w[j]   + a[j+n1];
               a[j*2+1] = w[j]   - a[j+n1];
               a[j*2+2] = w[j+1] + a[j+n1+1];
               a[j*2+3] = w[j+1] - a[j+n1+1];
            }
         }
         else {
            for( j = 0; j < n1; j++ ) {
               a[j*2]   = w[j] + a[j+n1];
               a[j*2+1] = w[j] - a[j+n1];
            }
         }
      }
      n1 = n1 + n1;
      odd = ( odd == 1 ) ? 0: 1;
   }
   if ( m%2 == 0 ) {
      for( j = 0; j < n; j++ ) {
         w[j] = a[j];
      }
   }
}

