#include "fundefs.h"

void synhr2d( int m, int n, double **a1, double **a2, double **w1, double **w2 )
// ---------------------------------------------------------------------
// -- 'anhr2d' does a 2-D Haar wavelet analysis on array 'a1'.
//     Output in 'w2'.
// ---------------------------------------------------------------------
{
   int i, k;
// ---------------------------------------------------------------------
   k = ilog2( m );
   for( i = 0; i < n; i++ ) {
      synthr( m, k, w2[i], a2[i] ); 
   }
   ltrans( n, m, a2, w1 );
   k = ilog2( n );
   for( i = 0; i < m; i++ ) {
      synthr( n, k, w1[i], a1[i] );
   }
}
