#include <float.h>
#include <math.h>

int check( int m, int n, double **a, double **w )
// ---------------------------------------------------------------------
// -- Routine 'check' checks the correctness of a 2-D Haar wavelet
//    followed by the synthesis on the result array 'a'. This should
//    be identical to the original ('w').
// ---------------------------------------------------------------------
{
   int    ok = 0;
   int    i, j;
   double eps;
// ---------------------------------------------------------------------
   eps = 4.0*DBL_EPSILON;
   for( i = 0; i < m; i++ ) {
      for( j = 0; j < n; j++ ) {
         if ( fabs( a[i][j] - w[i][j] ) > eps ) ok++;
      }
   }
   return( ok );
}
