#include "fundefs.h"

void anhr2d( int m, int n, double **a1, double **a2, double **w1, double **w2 )
// ---------------------------------------------------------------------
// -- 'anhr2d' does a 2-D Haar wavelet analysis on array 'a1'.
//     Output in 'w2'.
// ---------------------------------------------------------------------
{
   int i, k;
// ---------------------------------------------------------------------
   k = ilog2( n );
   for( i = 0; i < m; i++ ) {
      analhr( n, k, a1[i], w1[i] );
   }
   ltrans( m, n, w1, a2 );
   k = ilog2( m );
   for( i = 0; i < n; i++ ) {
      analhr( m, k, a2[i], w2[i] ); 
   }
}
