#include <stdio.h>
#include <math.h>

void nflops( int m, int *mfli, int *mflt )
// ---------------------------------------------------------------------
// --- nflops calculates the number of flops for the complex-to-
//     complex Radix-4 FFT of length 2**m.
//     m should be >= 2.
// --- In the initialisation part it is assumed that the evaluation
//     of a Sine or Cosine function takes 10 flops.
// ---------------------------------------------------------------------
{
   int mfl2, mfl3, mdiv, mmod, m2, n, n12, n14, n24, n4;
// ---------------------------------------------------------------------
// --- Test input parameter.

   if ( m < 2 ) {
      printf( " *** Error in routine Nflops: m < 2 : m = %d\n", m );
      return;
   }
// ---------------------------------------------------------------------
// --- Marginal cases:

   if ( m == 2 ) {
      *mfli = 22; *mflt = 20;
      return;
   }
   if ( m == 3 ) {
      *mfli = 107; *mflt = 86;
      return;
   }
// ---------------------------------------------------------------------
// --- Initialisation part.

   m2    = ( m + 1 )/2;
   *mfli = 21* ( (int)pow( 4, m2 ) - 1 )/3  + m2;
// ---------------------------------------------------------------------
// --- Transform part:

   n = (int)pow( 2, m );
   if ( n < 64 ) {
      if ( n == 16 ) {
         *mflt = 264;
      }
      else if ( n == 32 ) {
         *mflt = 644;
      }
   }
   else {
      n4   = n/4;
      mfl2 = 54*n4 + 48;
      mmod = m%4;
      mdiv = ( m - 1 )/4;
      n12  = 23*n4;
      n14  = 48*n4;
      n24  = n14 + n14;
      mfl3 = ( mdiv - 1 )*n24;
      switch( mmod ) {
      case 0:
         mfl3 = mfl3 + n24;
         break;
      case 1:
         mfl3 = mfl3 + n12;
         break;
      case 2:
         mfl3 = mfl3 + n14;
         break;
      case 3:
         mfl3 = mfl3 + n14 + n12;
         break;
      }
      *mflt = mfl2 + mfl3;
   }
}
