#include "fundefs.h"

void sym7mxv( int n1, int n2, int n3, double **a, double *x, double *y )
/* --------------------------------------------------------------------
   -- sym7mxv does a matrix-vector multiply of a banded symmetric
      matrix originating from a 3-D finite difference scheme. Only
      the upper diagonal part of matrix a is stored in a[*][0:3].
   --------------------------------------------------------------------*/
{
   extern long flops;
   int i, ntot, n12;
// ---------------------------------------------------------------------
   n12  = n1*n2;
   ntot = n12*n3;
   y[0] = a[0][0]*x[0] + a[0][1]*x[1] + a[0][2]*x[n1] + a[0][3]*x[n12];
   for( i = 1; i < n1; ++i ) {
      y[i] = a[i][0]*x[i]     + a[i][1]*x[i+1]    + a[i][2]*x[i+n1] +
             a[i][3]*x[i+n12] + a[i-1][1]*x[i-1];
   }
   for( i = n1; i < n12; ++i ) {
      y[i] = a[i][0]*x[i]     + a[i][1]*x[i+1]   + a[i][2]*x[i+n1] +
             a[i][3]*x[i+n12] + a[i-1][1]*x[i-1] + a[i-n1][2]*x[i-n1];
   }
   for( i = n12; i < ntot - n12; ++i ) {
      y[i] = a[i][0]*x[i]     + a[i][1]*x[i+1]   + a[i][2]*x[i+n1] +
             a[i][3]*x[i+n12] + a[i-1][1]*x[i-1] + a[i-n1][2]*x[i-n1] +
             a[i-n12][3]*x[i-n12];
   }
   for( i = ntot - n12; i < ntot - n1; ++i ) {
      y[i] = a[i][0]*x[i]       + a[i][1]*x[i+1] + a[i][2]*x[i+n1] +
             a[i-1][1]*x[i-1] + a[i-n1][2]*x[i-n1] + a[i-n12][3]*x[i-n12];
   }
   for( i = ntot - n1; i < ntot - 1; ++i ) {
      y[i] = a[i][0]*x[i]       + a[i][1]*x[i+1] + a[i-1][1]*x[i-1] +
             a[i-n1][2]*x[i-n1] + a[i-n12][3]*x[i-n12];
   }
   y[ntot-1] = a[ntot-1][0]*x[ntot-1]       + a[ntot-2][1]*x[ntot-2] +
             a[ntot-n1-1][2]*x[ntot-n1-1] + a[ntot-n12-1][3]*x[ntot-n12-1];   
   flops += 14 + 18*( n1 -1 ) + 22*n1*( n2 - 1 ) + 
                 13*( n1*n2*( n3 - 2 ) ); // -- Keep track of flops.
} // -- End of sym7mxv 
