double nrm2( int n, double *x )
// ---------------------------------------------------------------------
// -- nrm2 computes the L2-norm of a vector of length n.
// ---------------------------------------------------------------------
{
   extern long flops;
   int    i, rest;
   double sum = 0.0;
// ---------------------------------------------------------------------
   rest = n - n%4;
   for( i = 0; i < rest; i += 4 ) {
      sum += x[i]*x[i] + x[i+1]*x[i+1] + x[i+2]*x[i+2] + x[i+3]*x[i+3];
   }
   for( i = rest; i < n; ++i ) {
      sum += x[i]*x[i];
   }
   flops += 2*n;
   return sum;
}
