#include <math.h>

void rotf( double arg, double *c, double *s )
/*----------------------------------------------------------------------
  --- rotf recovers rotation factors c & s from 'arg' for the Givens
      transformation (used in rgmres).
  ----------------------------------------------------------------------*/
{
   extern long int flops;
   double la, lc, ls;
// ---------------------------------------------------------------------
   if ( arg == 0.0 ) {
      lc = 0.0;
      ls = 1.0;
   }
   else if ( fabs( arg ) < 1.0 ) {
      ls = 2.0*arg;
      lc = sqrt( 1.0 - ls*ls );
      flops += 12;
   }
   else {
      lc = 2.0/arg;
      la = 1.0 - lc*lc;
      if ( la >= 0.0 ) ls = sqrt( la );
      else ls = 1.0;
      flops += 12;
   }
   *c = lc; *s = ls;
}
