void pcoefs( int m, double *gamma )
// ---------------------------------------------------------------------
// -- Function 'pcoefs' provides the polynomial coefficients for a
//    left polynomial preconditioner to a degree <= 12.
//    int     m          : degree of polynomial.
//    double  gamma[m+1] : Array of polynomial coefficients.
// ---------------------------------------------------------------------
{
   if ( m ==  1 ) {
       gamma[0] = 1.2;
       gamma[1] = 0.8;
   }
   else if ( m == 2 ) {
       gamma[0] = 1.1428571428571428;
       gamma[1] = 1.7142857142857142;
       gamma[2] = 1.1428571428571428;
   }
   else if ( m == 3 ) {
       gamma[0] = 0.88888888888888888;
       gamma[1] = 1.3333333333333333;
       gamma[2] = 2.6666666666666666;
       gamma[3] = 1.7777777777777777;
   }
   else if ( m == 4 ) {
       gamma[0] = 0.90909090909090909;
       gamma[1] = 0.36363636363636364;
       gamma[2] = 1.4545454545454545;
       gamma[3] = 4.3636363636363636;
       gamma[4] = 2.9090909090909091;
   }
   else if ( m == 5 ) {
       gamma[0] =  1.0769230769230769;
       gamma[1] =  0.61538461538461542;
       gamma[2] = -1.2307692307692308;
       gamma[3] =  1.2307692307692308;
       gamma[4] =  7.384615384615385;
       gamma[5] =  4.9230769230769234;
   }
   else if ( m == 6 ) {
       gamma[0] =  1.0666666666666667;
       gamma[1] =  1.6;     
       gamma[2] =  0.0;
       gamma[3] = -5.333333333333333;
       gamma[4] =  0.0;
       gamma[5] =  12.8;    
       gamma[6] =  8.533333333333333;
   }
   else if ( m == 7 ) {
       gamma[0] =  0.94117647058823528;
       gamma[1] =  1.411764705882353;
       gamma[2] =  3.7647058823529411;
       gamma[3] = -0.94117647058823528;
       gamma[4] = -15.058823529411764;
       gamma[5] = -3.7647058823529411;
       gamma[6] =  22.588235294117649;
       gamma[7] =  15.058823529411764;
   }
   else if ( m == 8 ) {
       gamma[0] =   18.0/19.0;
       gamma[1] =    8.0/19.0;
       gamma[2] =   48.0/19.0;
       gamma[3] =  208.0/19.0;
       gamma[4] =  -32.0/19.0;
       gamma[5] = -704.0/19.0;
       gamma[6] = -256.0/19.0;
       gamma[7] =  768.0/19.0;
       gamma[8] =  512.0/19.0;
   }
   else if ( m == 9 ) {
       gamma[0]  =    22.0/21.0;
       gamma[1]  =     4.0/7.0;
       gamma[2]  =   -16.0/7.0;
       gamma[3]  =    16.0/3.0;
       gamma[4]  =    32.0;
       gamma[5]  =     0.0;
       gamma[6]  =  -256.0/3.0;
       gamma[7]  =  -256.0/7.0;
       gamma[8]  =   512.0/7.0;
       gamma[9] =  1024.0/21.0;
   }
   else if ( m == 10 ) {
       gamma[0]  =    24.0/23.0;
       gamma[1]  =    36.0/23.0;
       gamma[2]  =   -24.0/23.0;
       gamma[3]  =  -304.0/23.0;
       gamma[4]  =   256.0/23.0;
       gamma[5]  =  2048.0/23.0;
       gamma[6]  =   256.0/23.0;
       gamma[7]  = -4352.0/23.0;
       gamma[8]  = -2048.0/23.0;
       gamma[9] =  3072.0/23.0;
       gamma[10] =  2048.0/23.0;
   }
   else if ( m == 11 ) {
       gamma[0]  =    24.0/25.0;
       gamma[1]  =    36.0/25.0;
       gamma[2]  =    24.0/5.0;
       gamma[3]  =   -32.0/5.0;
       gamma[4]  =  -256.0/5.0;
       gamma[5]  =   512.0/25.0;
       gamma[6]  =  5888.0/25.0;
       gamma[7]  =   256.0/5.0;
       gamma[8]  = -2048.0/5.0;
       gamma[9] = -1024.0/5.0;
       gamma[10] =  6144.0/25.0;
       gamma[11] =  4096.0/25.0;
   }
   else if ( m == 12 ) {
       gamma[0]  =     26.0/27.0;
       gamma[1]  =      4.0/9.0;
       gamma[2]  =     32.0/9.0;
       gamma[3]  =    544.0/27.0;
       gamma[4]  =    -64.0/3.0;
       gamma[5]  =   -512.0/3.0;
       gamma[6]  =    256.0/9.0;
       gamma[7]  =   1792.0/3.0;
       gamma[8]  =    512.0/3.0;
       gamma[9] = -23552.0/27.0;
       gamma[10] =  -4096.0/9.0;
       gamma[11] =   4096.0/9.0;
       gamma[12] =   8192.0/27.0;
   }
} // End of pcoefs
