void lsqslv( int m, int n, double **a, double *x )
// ---------------------------------------------------------------------
// -- lsqslv solves the rectangular upper diagonal system Ax = b in
//    the Least Squares sense: It is assumed that m <= n and
//    a[n][m] has only a non-zero upper triangle of order m.
//    On entry x contains the RHS. On exit it contains the
//    solution vector.
// ---------------------------------------------------------------------
{
   extern long int flops;

   int    i, j;
   double tmp;
// ---------------------------------------------------------------------
   for( j = m-1; j>= 0; --j ) {
      x[j] = x[j]/a[j][j];
      tmp  = x[j];
      for( i = j-1; i >= 0; --i ) {
         x[i] = x[i] - tmp*a[i][j];
      }
   }
   flops += ( m*( m + 1 ) )/2;
} // -- End of lsqslv
