#include <stdio.h>
#include <stdlib.h>
#include "fundefs.h"
#define  Max( a, b ) ( (a > b) ? a : b )

int main()
{
   int    n, nrhs;
   int    ierr, ok, nops, nrep;
   int    i;
   int    j, k, l;
   int    *ipvt;
   double *a, *b;
   double dn, norma, ops, speed, t1, time1, time2, totime;
   FILE   *inl;
// ---------------------------------------------------------------------
   state( "mod2b" );
   prthead();
   nrhs = 1;
   inl = fopen( "mod2b.in", "r" );
   while( ( fscanf( inl, "%d%d\n", &n, &nrep ) != EOF ) ) {
      dn    = (double)n;
      a     = calloc( n*n, sizeof(double) );
      b     = calloc( n, sizeof(double) );
      ipvt  = calloc( n, sizeof(int) );
      ops   = ( 2.0*dn*dn*dn )/3.0 + 2.0*dn*dn;
      time1 = 0.0;
      time2 = 0.0;
// ---------------------------------------------------------------------
// -- Generate problem matrix and RHS.

      for( i = 0; i < nrep; i++ ) {
         gendat( n, a, b );
// ---------------------------------------------------------------------
// -- Factorise.

         t1 = cclock();
         dgetrf( n, n, a, n, ipvt, ierr, b );
         time1 = time1 + ( cclock() - t1 );
// ---------------------------------------------------------------------
// -- Stop on ierr != 0.

         if ( ierr != 0 ) {
            printf( "Error %d in DGETRF\n", ierr );
            exit;
         }
// ---------------------------------------------------------------------
// -- Solve factorised system.

         t1 = cclock();
         dgetrs( "N", n, nrhs, a, n, ipvt, b, 1, ierr );
         time2 = time2 + ( cclock() - t1 );
// ---------------------------------------------------------------------
// -- Stop on ierr != 0.

         if ( ierr != 0 ) {
            printf( "Error %d in DGETRS\n", ierr );
            exit;
         }
      }
// ---------------------------------------------------------------------
// -- Check correctness.

      ok     = check( n, b );
      time1  = time1/nrep;
      time2  = time2/nrep;
      totime = time1 + time2;
      speed  = 1.0e-6*ops/Max( 1.0e-9, totime );
      prtspeed( n, time1, time2, totime, speed, ok );
      free( a ); free( b ); free( ipvt ); 
   }
   printf( "--------------------------------------------------------------" );
   printf( "----\n" );
   printf( "Ran OK\n" );
}
