#include <math.h>

int idamax( int n, double *dx, int incx )
{
// -- System generated locals
   int    ret_val, i1;
   double d1;

// -- Local variables
   int i, ix;
   double dmax;

/*  Purpose
    =======

       finds the index of element having max. absolute value.
       jack dongarra, linpack, 3/11/78.
       modified 3/93 to return if incx .le. 0.
       modified 12/3/93, array(1) declarations changed to array(*)         */
// --------------------------------------------------------------------------
// -- Function Body

   ret_val = 0;
   if ( n < 1 || incx <= 0 ) return ret_val;
   if ( n == 1 ) return 0;
   dmax = fabs( dx[0] );
   if ( incx == 1 ) {               // -- Code for increment == 1
      for( i = 1; i < n; ++i ) {
         d1 = fabs( dx[i] );
         if ( d1 > dmax ) {
            ret_val = i;
            dmax    = d1;
         }
      }
   }
   else {                           // -- Code for increment != 1
      ix = incx;
      for( i = 1; i < n; ++i ) {
         d1 = fabs( dx[ix] );
         if ( d1 > dmax ) {
            ret_val = i;
            dmax    = d1;
         }
         ix += incx;
      }
   }
   return ret_val;
} // -- idamax
