#include "dfmaxmin.h"

int dgetrf( int m, int n, double *a, int lda, int *ipiv, int info )
{
   /* System generated locals */
   int i1, i2, i3, i4, i5;

   /* Local variables */
   int i, j, jb, nb;
   extern int dgemm( char *, char *, int, int, int, double, double *, int,
                     double *, int, double, double *, int );
   extern int dtrsm( char *, char *, char *, char *, int, int, double,
                     double *, int, double *, int ),
              dgetf2( int, int, double *, int, int *, int * ),
              xerbla( char *, int );
   extern int ilaenv( int, char *, char *, int, int, int, int );
   extern int dlaswp( int, double *, int, int, int, int *, int );
   int iinfo;
   int mtest;

/*  -- LAPACK routine (version 3.1) --
       Univ. of Tennessee, Univ. of California Berkeley and NAG Ltd..
       November 2006

    Purpose
    =======
    DGETRF computes an LU factorization of a general M-by-N matrix A
    using partial pivoting with row interchanges.

    The factorization has the form
       A = P * L * U
    where P is a permutation matrix, L is lower triangular with unit
    diagonal elements (lower trapezoidal if m > n), and U is upper
    triangular (upper trapezoidal if m < n).

    This is the right-looking Level 3 BLAS version of the algorithm.

    Arguments
    =========
    M       (input) INTEGER
            The number of rows of the matrix A.  M >= 0.
    N       (input) INTEGER
            The number of columns of the matrix A.  N >= 0.
    A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
            On entry, the M-by-N matrix to be factored.
            On exit, the factors L and U from the factorization
            A = P*L*U; the unit diagonal elements of L are not stored.
    LDA     (input) INTEGER
            The leading dimension of the array A.  LDA >= max(1,M).
    IPIV    (output) INTEGER array, dimension (min(M,N))
            The pivot indices; for 1 <= i <= min(M,N), row i of the
            matrix was interchanged with row IPIV(i).
    INFO    (output) INTEGER
            = 0:  successful exit
            < 0:  if INFO = -i, the i-th argument had an illegal value
            > 0:  if INFO = i, U(i,i) is exactly zero. The factorization
                  has been completed, but the factor U is exactly
                  singular, and division by zero will occur if it is used
                  to solve a system of equations.
    ===================================================================== */
// -- Test the input parameters.
   info = 0;
   mtest = max( 1, m );
   if ( m < 0 )  info = -1;
   else if ( n < 0 ) info = -2;
   else if ( lda < mtest ) info = -4;
   if ( info != 0 ) {
      xerbla( "DGETRF", -info );
      return 0;
   }

// -- Quick return if possible.
   if ( m == 0 || n == 0 )  return 0;

// -- Determine the block size for this environment.

   nb = ilaenv( 1, "DGETRF", " ", m, n, -1, -1 );
   if ( nb <= 1 || nb >= min( m, n ) ) {

// -- Use unblocked code. 
      dgetf2( m, n, a, lda, ipiv, &info );
   }
   else {

// -- Use blocked code.

      i1 = min( m, n );
      i2 = nb;
      for( j = 0; j < i1; j += i2 ) {

// --    Computing MIN.
         i3 = min( m, n ) - j;
         jb = min( i3, nb );

// --    Factor diagonal and subdiagonal blocks and test for exact singularity.
         dgetf2( m - j, jb, a+j*lda+j, lda, ipiv+j, &iinfo );

// --    Adjust INFO and the pivot indices. */
         if ( info == 0 && iinfo > 0 ) info = iinfo + j - 1;

// --    Computing MIN.
         i3 = min( m, j + jb );
         for( i = j; i < i3; ++i ) {
            ipiv[i] = j + ipiv[i];
         }

// --    Apply interchanges to columns 0:J.
         dlaswp( j, a, lda, j, j+jb, ipiv, 1 );
         if ( j + jb <= n ) {

// --       Apply interchanges to columns J+JB:N-1. 
            dlaswp( n-j-jb, a+jb+j-1, lda, j, j+jb, ipiv, 1 );

// --       Compute block row of U. 
            i3 = n - j - jb + 1;
            dtrsm( "Left", "Lower", "No transpose", "Unit", jb, n-j-jb, 1.0,
                   a+j*lda+j, lda, a+j*lda+jb, lda );
            if ( j + jb <= m ) {

// --          Update trailing submatrix. 
               dgemm( "No transpose", "No transpose", m-j-jb, n-j-jb, jb, -1.0,
                      a+(jb+j)*lda+j, lda, a+j*lda+jb+j, lda, 1.0,
                      a+(jb+j)*lda+jb+j, lda );
            }
         }
      }
   }
   return 0;
} // -- End of dgetrf
