#include <float.h>
#include <math.h>
#include "dfmaxmin.h"

int dgetf2( int m, int n, double *a, int lda, int *ipiv, int *info )
{
// -- System generated locals.
   int i1;
   double d1;

// -- Local variables.
   int    i, j, jp;
   double sfmin;
   int    linfo, mtest;
   extern int dger( int, int, double, double *, int, double *, int, double *,
                    int );
   extern int dscal( int, double, double *, int );
   extern int dswap( int, double *, int, double *, int );
   extern int idamax( int, double *, int );
   extern int xerbla( char *, int );


/*  -- Following LAPACK routine (version 3.1) (without f2c, however, AvdS) --
       Univ. of Tennessee, Univ. of California Berkeley and NAG Ltd..
       November 2006

  Purpose
  =======

  DGETF2 computes an LU factorization of a general m-by-n matrix A
  using partial pivoting with row interchanges.

  The factorization has the form
     A = P * L * U
  where P is a permutation matrix, L is lower triangular with unit
  diagonal elements (lower trapezoidal if m > n), and U is upper
  triangular (upper trapezoidal if m < n).

  This is the right-looking Level 2 BLAS version of the algorithm.

  Arguments
  =========
  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.
  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.
  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the m by n matrix to be factored.
          On exit, the factors L and U from the factorization
          A = P*L*U; the unit diagonal elements of L are not stored.
  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).
  IPIV    (output) INTEGER array, dimension (min(M,N))
          The pivot indices; for 1 <= i <= min(M,N), row i of the
          matrix was interchanged with row IPIV(i).
  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -k, the k-th argument had an illegal value
          > 0: if INFO = k, U(k,k) is exactly zero. The factorization
               has been completed, but the factor U is exactly
               singular, and division by zero will occur if it is used
               to solve a system of equations.                            */
// -------------------------------------------------------------------------
// -- Function Body; Test the input parameters.
   linfo = *info;
   linfo = 0;
   mtest = max( 1, m );
   if ( m < 0 ) linfo = -1;
   else if ( n < 0 ) linfo = -2;
   else if ( lda < mtest ) linfo = -4;
   if ( linfo != 0 ) {
      xerbla( "DGETF2", -linfo );
      return 0;
   }

// -- Quick return if possible.
   if ( m == 0 || n == 0 ) {       
      return 0;
   }

// -- Compute machine safe minimum.
   sfmin = DBL_MIN;

   i1 = min( m, n );
// -- Find pivot and test for singularity.
   for( j = 0; j < i1; ++j ) {
      jp = j + idamax( m-j, a+j*lda+j, lda );
      ipiv[j] = jp;

// -- Apply the interchange to columns 0:N-1.
      if ( a[jp*lda+j] != 0.0 ) {
         if ( jp != j ) {
            dswap( n, a+j*lda, 1, a+jp*lda, 1 );
         }
// -- Compute elements J:M-1 of (J-1)-th column.
         if ( j < m ) {
            d1 = a[j*lda+j];
            if ( fabs( d1 ) >= sfmin ) {
               d1 = 1.0/d1;
               dscal( m-j-1, d1, a+(j+1)*lda+j, lda );
            }
            else {
               for( i = 0; i < m-j; ++i ) {
                  a[j*lda+j+i] /= a[j*lda+j];
               }
            }
         }
      }
      else if ( *info == 0 ) *info = j;
      if ( j < i1 ) {

// -- Update trailing submatrix.
         dger( m-j-1, n-j-1, -1.0, a+(j+1)*lda+j, lda, a+j*lda+j+1, 1,
               a+(j+1)*lda+j+1, lda );
      }
   }
   return 0;
} // -- End of dgetf2
