#include <stdio.h>
#include <float.h>
#include <math.h>

int check( int n, double *x )
// --------------------------------------------------------------------
// -- Routine 'check' checks the solution vector 'x' in 'b = Ax'. The
//    check is possible because of the special definition of 'A' & 'b'.
// --------------------------------------------------------------------
{
   int    i, ok = 0;
   double eps;
// --------------------------------------------------------------------
   eps = 4.0e4*n*n*DBL_EPSILON; 
   for( i = 0; i < n; i++ ) {
      if ( fabs( x[i] - 1.0 ) > eps ) ok++;
   }
   return( ok );
}
