void mxm( int lda, int m, int l, int n, double **a, double **b,
          double **c )
// ---------------------------------------------------------------------
// --- Routine 'mxm' does a matrix-matrix multiplication 'AB = C'
//     using an dotproduct implementation. The code is 4 times unrolled.
// ---------------------------------------------------------------------
{
   int    i, j, k, lf;
// ---------------------------------------------------------------------
   lf = l - l%4;
   for( i = 0 ; i < m; i++ ) {
      for( j = 0; j < lf; j+= 4 ) {
         for( k = 0; k < n; k++ ) {
            c[i][k] = c[i][k] + a[i][j]  *b[j][k]   + a[i][j+1]*b[j+1][k]
                              + a[i][j+2]*b[j+2][k] + a[i][j+3]*b[j+3][k];
         }
      }
   }
   for( i = 0 ; i < m; i++ ) {
      for( j = lf; j < l; j++ ) {
         for( k = 0; k < n; k++ ) {
            c[i][k] = c[i][k] + a[i][j]*b[j][k];
         }
      }
   }
}
