#include <string.h>

void mvddot( double **a, double *b, double *c, int m, int n )
// ---------------------------------------------------------------------
// --- Routine 'mvddot' does a matrix-vector multiplication 'Ab = c'
//     using an dotproduct implementation.
// ---------------------------------------------------------------------
{
   int    i, j, mf;
// ---------------------------------------------------------------------
   for( i = 0; i < m; i++ ) {
      c[i] = 0.0;
   }
   mf = m - m%4;
   for( i = 0 ; i < mf; i+= 4 ){
      for( j = 0; j < n; j++ ){
         c[i]   = c[i]   + a[i][j]  *b[j];
         c[i+1] = c[i+1] + a[i+1][j]*b[j];
         c[i+2] = c[i+2] + a[i+2][j]*b[j];
         c[i+3] = c[i+3] + a[i+3][j]*b[j];
      }
   }
   for( i = mf; i < m; i++ ){
      for( j = 0; j < n; j++ ){
         c[i] = c[i] + a[i][j]*b[j];
      }
   }
}
