#include <stdio.h>
#include "fundefs.h"

int main()
/* ---------------------------------------------------------------------
  **********************************************************************
  *** This program is part of the EuroBen Benchmark                  ***
  *** Copyright: EuroBen Group p/o                                   ***
  ***            NCF/HPC Research                                    ***
  ***            L.J. Costerstraat 5                                 ***
  ***            6827 AR Arnhem                                      ***
  ***            The Netherlands                                     ***
  ***                                                                ***
  *** Author of this program: Aad van der Steen, after a Fortran     ***
  *** version of Armin Friedli, ETH Zuerich.                         ***
  *** Date                    Summer 2010                            ***
  **********************************************************************
   Purpose of module 1f
   --------------------
    Timing tests for the elementary functions (64-bits precision).
  
    The elementary functions as provided by the C language are timed.
    The intervals for the arguments for the various functions
    are the ones used in the ELEFUNT package, a collection of programs
    to test the accuracy of the elementary functions, by W.J. Cody and
    W. Waite.
   ---------------------------------------------------------------------*/
{
   const int mrep = 20000, nfmax = 35, nmax = 50, nn = 34;
   double    beta, xmin, xmax, xint[nfmax][2], yint[2];
   double    tab[nfmax][nmax];
   int       i, it, iy, maxi;
   int       narr[34] = {   1,    2,    3,    4,    5,    6,    7,    8,    9,
                           10,   20,   30,   40,   50,   60,   70,   80,   90,
                          100,  200,  300,  400,  500,  600,  700,  800,  900,
                         1000, 2000, 4000, 6000, 8000,10000,20000 };
   char      *ident[nfmax];
// ---------------------------------------------------------------------
// -- Identify program.
   state( "mod1f" );
// ---------------------------------------------------------------------
// -- Set seed for random generator.
   setrand( 2011 );
   maxi = 35;
   efvec( maxi, mrep, tab, nn, narr, ident, xint, yint );
   wrtab( maxi, tab, nn, narr, ident, xint, yint );

   printf( "\n" );
   printf( " ----------- E n d   o f   T e s t --------------\n" );
   printf( " --- NOTE: n1/2 is only a rough approximation ---\n" );
   printf( " ------------------------------------------------\n" );
   printf( "Ran OK\n" );
} // -- End of mod1f
