#include <math.h>
#include "fundefs.h"

void stan( void )
// ---------------------------------------------------------------------
// -- Function to test Tan/Cot(x)
// ---------------------------------------------------------------------
{
   int    i, j;
   double a, ait, albeta, b, beta, del, half, pi, r6, r7, three, w, x,
          xl, xn, x1, y, z, zero, zz, dummy;
   char   *cm[4] = { "Tan(x)    ", "Tan(x)    ", "Tan(x)    ", "Cot(x)    " };
   extern int    ibeta, irnd, it, n;
   extern double xmax, xmin;
// ---------------------------------------------------------------------
   beta    = (double)ibeta;
   albeta  = log( beta );
   ait     = (double) it;
   zero    = 0.0;
   half    = 0.5;
   pi      = 3.141592653589793;
   a       = zero;
   b       = pi*0.25;
   xn      = (double)n;
// ---------------------------------------------------------------------
// -- Random argument accuracy tests.
// ---------------------------------------------------------------------
   for( j = 1; j <= 4; ++j ) {
      x1 = zero;
      r6 = zero;
      r7 = zero;
      del = ( b - a )/xn;
      xl = a;
      for( i = 1; i <= n; ++i ) {
         x = del*rand64() + xl;
         y = x*half;
         x = y + y;
         if ( j == 4 ) goto L10;
         z  = tan( x );
         zz = tan( y );
         w  = 1.0;
         if ( z == zero ) goto L20;
         w  = ( ( half - zz ) + half )*( ( half + zz ) + half );
         w = ( z - ( zz + zz )/w )/z;
         goto L20;
L10:     z  = cot( x );
         zz = cot( y );
         w  = 1.0;
         if ( z == zero ) goto L20;
         w  = ( ( half - zz ) + half )*( ( half + zz ) + half );
         w = ( z + w/( zz + zz ) )/z;
L20:     w  = fabs( w );
         if ( w > r6 ) {
            r6 = w;
            x1 = x;
         }
         r7 = r7 + w*w;
         xl = xl + del;
      }
      r7 = sqrt( r7/xn );
      summ( cm[j-1], j, r6, r7, a, b, dummy, dummy, x1, dummy );
      if ( j == 1 ) {
         a = pi*0.875;
         b = pi*1.125;
      }
      a = pi*6.0;
      b = a + pi*0.25;
   }
} // -- End of stan
