#include <math.h>
#include "fundefs.h"

void spower( void )
// ---------------------------------------------------------------------
// -- Function tests pow(x,y).
// ---------------------------------------------------------------------
{
   int    i, j;
   double a, ait, albeta, alxmax, b, beta, c, del, dely, one, onep5, r6,
          r7, scale, two, v, w, wsave, x, x1, xn, xsq, xl, y, y1, y2,
          z, zero, zz;
   char   *cm[4] = { "x**1.0    ", "xsq**1.5  ", "xsq**1.5  ", "x**y      " };
   extern int    ibeta, irnd, it, n;
   extern double xmax, xmin;
// ---------------------------------------------------------------------
   beta   = (double)ibeta;
   albeta = log( beta );
   ait    = (double)it;
   alxmax = log( xmax );
   zero   = 0.0;
   one    = (double)1;
   two    = one + one;
   onep5  = ( two + one )/two;
   scale  = one;
   j      = ( it + 1 )/2;
   for( i = 1; i <= j; ++i ) {
      scale = scale*beta;
   }
   a      = one/beta;
   b      = one;
   c      = -max( alxmax, -log( xmin ) )/log( 100 );
   dely   = -c - c;
   xn     = (double)n;
   y1     = zero;
// ---------------------------------------------------------------------
// -- Random argument accuracy tests.
// ---------------------------------------------------------------------
   for( j = 1; j <= 4; ++j ) {
      x1  = zero;
      r6  = zero;
      r7  = zero;
      del = (b - a)/xn;
      xl  = a;
      for( i = 1; i <= n; ++i ) {
         x  = del*rand64() + xl;
         if ( j != 1 ) goto L10;
         zz = pow( x, one );
         z  = x;
         goto L30;
L10:     w   = scale*x;
         x   = ( x + w ) - w;
         xsq = x*x;
         if ( j == 4 ) goto L20;
         zz = pow( xsq, onep5 );
         z  = x*xsq;
         goto L30;
L20:     y  = dely*rand64() + c;
         y2 = ( y/two + y ) - y;
         y  = y2 + y2;
         z  = pow( x, y );
         zz = pow( xsq, y2 );
L30:     w  = one;
         if ( zz != zero ) w = ( z - zz )/z;
         if ( w > r6 ) {
            r6 = w;
            x1 = x;
            if ( j == 4 ) y1 = y;
         }
         r7 = r7 + w*w;
         xl = xl + del;
     }
     r7 = sqrt( r7/xn );
     if ( j == 4 ) {
        w     = c + dely;
        wsave = w;
     }
     summ( cm[j-1], j, r6, r7, a, b, c, wsave, x1, y1 );
     if ( j == 1 ) goto L40;
     a = 0.01;
     b = 10.0;
     if ( j == 3 ) goto L40;
     a = one;
     b = exp( alxmax/3.0 );
L40: continue;
   }
} // -- End of spower
