#include <math.h>
#include "fundefs.h"

void slog( void )
// ---------------------------------------------------------------------
// -- Function to test Log(x)
// ---------------------------------------------------------------------
{
   int    i, j;
   double a, ait, albeta, b, beta, c, del, eight, half, one, r6, r7,
          tenth, w, x, xl, xn, x1, y, z, zero, zz, dummy;
   char   *cm[4] = { "Log(x)    ", "Log(x)    ", "Log10(x)  ", "Log(x)    " };
   extern int    ibeta, irnd, it, n;
   extern double xmax, xmin;
// ---------------------------------------------------------------------
   beta   = (double)ibeta;
   albeta = log( beta );
   ait    = (double)it;
   j      = it/3;
   zero   = 0.0;
   half   = 0.5;
   eight  = 8.0;
   tenth  = 0.1;
   one    = 1.0;
   c      = one;
   for( i = 1; i <= j; ++i ) {
      c = c/beta;
   }
   b  = one + c;
   a  = one - c;
   xn = (double)n;
// ---------------------------------------------------------------------
// -- Random argument accuracy tests.
// ---------------------------------------------------------------------
   for( j = 1; j <= 4; ++j ) {
      x1 = zero;
      r6 = zero;
      r7 = zero;
      del = (b - a)/xn;
      xl = a;
      for( i = 1; i <= n; ++i ) {
         x  = del*rand64() + xl;
         if ( j != 1 ) goto L10;
         y  = ( x - half ) - half;
         zz = log( x );
         z  = one/3.0;
         z  = y * ( z - y/4.0 );
         z  = ( z - half )*y*y + y;
         goto L40;
L10:     if ( j != 2 ) goto L20;
         x  = ( x + eight ) - eight;
         y  = x + x/16.0;
         z  = log( x );
         zz = log( y ) - 7.77468164348425806061320404202632862e-5;
         zz = zz - 31.0/512.0;
         goto L40;
L20:     if ( j != 3 ) goto L30;
         x  = ( x + eight ) - eight;
         y  = x + x*tenth;
         z  = log10( x );
         zz = log10( y ) - 3.77060158225040750199971243024241707e-4;
         zz = zz - 21.0/512.0;
         goto L40;
L30:     z  = log( x*x );
         zz = log( x );
         zz = zz + zz;
L40:     w = one;
         if ( z != zero ) w = ( z - zz )/z;
         z = sign( w, z );
         w = fabs( w );
         if ( w <= r6 ) goto L50;
         r6 = w;
         x1 = x;
L50:     r7 = r7 + w*w;
         xl = xl + del;
      }
      r7 = sqrt( r7/xn );
      summ( cm[j-1], j, r6, r7, a, b, dummy, dummy, x1, dummy );
      if ( j > 1 ) goto L60;
      a = sqrt( half );
      b = 15.0/16.0;
      goto L80;
L60:  if ( j > 2 ) goto L70;
      a = sqrt( tenth );
      b = 0.9;
      goto L80;
L70:  a = 16.0;
      b = 240.0;
L80:  continue;
   }
} // -- End of slog

