#include <math.h>
#include "fundefs.h"

void sexp( void )
// ---------------------------------------------------------------------
// -- Function tests exp(x).
// ---------------------------------------------------------------------
{
   int    i, j;
   double a, ait, albeta, b, beta, d, del, one, r6, r7, two, ten, v, w,
          x, x1, xn, xl, y, z, zero, zz, dummy;
   char   *cm[3] = { "Exp(x)    ", "Exp(x)    ", "Exp(x)    " };
   extern int    ibeta, irnd, it, n;
   extern double xmax, xmin;
// ---------------------------------------------------------------------
   beta   = (double)ibeta;
   albeta = log( beta );
   ait    = (double)it;
   one    = 1.0;
   two    = 2.0;
   ten    = 10.0;
   zero   = 0.0;
   v      = 0.0625;
   a      = two;
   b      = log( a )*0.5;
   a      = -b + v;
   d      = log( 0.9*xmax );
   xn     = (double)n;
// ---------------------------------------------------------------------
// -- Random argument accuracy tests.
// ---------------------------------------------------------------------
   for( j = 1; j <= 3; ++j ) {
      x1  = zero;
      r6  = zero;
      r7  = zero;
      del = (b - a)/xn;
      xl  = a;
      for( i = 1; i <= n; ++i ) {
         x  = del*rand64() + xl;    // -- Purify arguments.
         y  = x - v;
         if ( y < zero ) x = y + v;
         z  = exp( x );
         zz = exp( y );
         if ( j == 1 ) goto L10;
         if ( ibeta != 10 ) z = z*0.0625 - 
                                z*2.44533210469205703894438669220964866e-3;
         if ( ibeta == 10 ) z = z*0.06 +
                                z*5.46678953079429610556133077903513440e-5;
         goto L20;
L10:     z = z - z*6.05869371865242138802891753776949155e-2;
L20:     w = one;
         if ( zz != zero ) w = ( z - zz )/zz;
         w = fabs( w );
         if ( w > r6 ) {
            r6 = w;
            x1 = x;
         }
         r7 = r7 + w*w;
         xl = xl + del;
     }
     r7 = sqrt( r7/xn );
     summ( cm[j-1], j, r6, r7, a, b, dummy, dummy, x1, dummy );
     if ( j == 2 ) goto L30;
     v = 45.0/16.0;
     a = -ten*b;
     b = 4.0*xmin*pow( beta, it );
     b = log( b );
     goto L40;
L30: a = -two*a;
     b =  ten*a;
     if ( b < d ) b = d;
L40: continue;
   }   
} // -- End of sexp
