#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "fundefs.h"

int main()
// ---------------------------------------------------------------------
// -- 'mod2i' tests the performance of sorting of an a array of integers
//     and doubles.
// ---------------------------------------------------------------------
{
   int    *idata, *src;
   int    *offset, *sizes;
   double *ddata;
   double corr, nops, speed, speed1, speed2, time1, time2;
   int    irep,  n, nprocs, nrep;
   int    me, nl, nu;
   int    nbd, nbi;
   int    ok1, ok2;
   FILE   *inl;
// ---------------------------------------------------------------------
   state( "mod2i" );
#pragma omp parallel
   nprocs = omp_get_num_threads();
   prthead( nprocs );
   inl = fopen( "mod2i.in", "r" );
   while( ( fscanf( inl, "%d%d\n", &n, &nrep ) != EOF ) ) {
      nbd = n*sizeof ( double );
      nbi = n*sizeof ( int );
      src    = calloc( n, sizeof( int ) );
      idata  = calloc( n, sizeof( int ) );
      ddata  = calloc( n, sizeof( double ) );
      offset = calloc( nprocs+1, sizeof(int) );
      nops   = n*(int)log2( (double)n ); 
      ranint( 1, n, n, src );
      evdist( n, nprocs, offset );
      time1 = cclock();
      for( irep = 1; irep <= nrep; irep++ ) {
         memcpy( idata, src, nbi );
#pragma omp parallel for private(me,nl,nu)
         for( me = 0; me < nprocs; ++me ) {
            nl = offset[me];
            nu = offset[me+1] - 1;
            iqsort( nl, nu, idata );
         }
      if ( nprocs > 1 ) imerge( n, nprocs, idata, offset );
      }
      time1 = cclock() - time1;
      time2 = cclock();
      for( irep = 1; irep <= nrep; irep++ ) {
         cp_arrd( n, src, ddata );
#pragma omp parallel for private(me,nl,nu)
         for( me = 0; me < nprocs; ++me ) {
            nl = offset[me];
            nu = offset[me+1] - 1;
            dqsort( nl, nu, ddata );
         }
      if ( nprocs > 1 ) dmerge( n, nprocs, ddata, offset );
      } 
      time2 = cclock() - time2;
      ok1 = icheck( n, idata );
      ok2 = dcheck( n, ddata );
      corr = cclock();
      for( irep = 1; irep <= nrep; irep++ ) {
         memcpy( idata, src, nbi );
      }
      corr = cclock() - corr;
      time1 = ( time1 - corr )/nrep;
      corr = cclock();
      for( irep = 1; irep <= nrep; irep++ ) {
         cp_arrd( n, src, ddata );
      }
      corr = cclock() - corr;
      time2 = ( time2 - corr )/nrep;
      speed  = 1.0e-6*nops;
      time1  = max( time1, 1.0e-9 );
      speed1 = speed/time1;
      time2  = max( time2, 1.0e-9 );
      speed2 = speed/time2;
      prtspeed( n, time1, speed1, ok1, time2, speed2, ok2 );
      free( src ); free( idata ); free( ddata );
   }
   printf( "---------------------------------------------------" );
   printf( "------------------------\nRan OK\n" );
}
