#include <stdlib.h>
#include <limits.h>
#include <stdio.h>
#include "fundefs.h"

void imerge( int n, int np, int *idata, int *ptr )
// ---------------------------------------------------------------------
// -- imerge does an np-way merge of sorted integer arrays.
// ---------------------------------------------------------------------
{
   int    i, is, j, maxd, pop;
   int    *head, *ub, *w;
// ---------------------------------------------------------------------
   is    = sizeof(int);
   head = calloc( np, is );
   ub   = calloc( np, is );
   w    = calloc( n, is ); 
   maxd = INT_MAX;           // -- Sentinel value for array "head".
// ---------------------------------------------------------------------
// -- Determine upperbounds of partitions of idata.

   for( i = 0; i < np; ++i ) {
      ub[i] = ptr[i+1] - 1;
   }
// ---------------------------------------------------------------------
// -- Merge.

   for( j = 0; j < n; ++j ) {
      for( i = 0; i < np; ++i ) {
         if ( ptr[i] <= ub[i] ) {
            head[i] = idata[ptr[i]];
         }
         else {
            head[i] = maxd;
         }
      }
      w[j] = i_minval( np, head );
      pop  = i_minloc( np, head );
      ptr[pop] = min( ptr[pop] + 1, ub[pop] + 1 );
   }
   cp_arri( n, w, idata );
   free( head );
   free( ub );
   free( w );
} // -- End of imerge.
