#include <stdlib.h>

void evdist( int n, int nprocs, int *offset )
// ---------------------------------------------------------------------
// -- Routine 'evdist' distributes 'n' elements as evenly as possible
//    over 'nodes' processors. The actual number of elements per
//    processor are returned in array 'sizes'.
// -- Also the base addresses for the distribution of a global 1-D
//    array are computed and stored in array 'offset'.
//----------------------------------------------------------------------
{
   int i, non, rest;
   int *sizes;
//----------------------------------------------------------------------
   sizes = calloc( nprocs, sizeof(int) ); 
   non   = n/nprocs;
   rest  = n%nprocs;
   for( i = 0; i < nprocs; ++i ) {        // -- Set sizes.
      sizes[i] = non;
      if( i < rest ) sizes[i] = non + 1;
   }
   offset[0] = 0;                         // -- Set base addresses.
   offset[nprocs] = n;                    // -- Last element is a
   for( i = 1; i < nprocs; ++i ) {        // -- sentinel for merging.
      offset[i] = offset[i-1] + sizes[i-1];
   }
   free( sizes );
} // -- End of evdist
