#include <float.h>
#include "fundefs.h"

int d_minloc( int n, double *a )
// ---------------------------------------------------------------------
// -- d_minloc returns the location of the first minimum value in an 
//    double array "a" of length "n".
// ---------------------------------------------------------------------
{
   int    i, loc;
   double lmf, mf;
// ---------------------------------------------------------------------
   mf  = DBL_MAX;
   lmf = mf;
   loc = 0;
   for( i = 0; i < n; ++i ) {
      mf = min( mf, a[i] );
      if ( lmf != mf ) {
         lmf = mf;
         loc = i;
      }
   }
   return( loc );
} // -- End of d_minloc
