#include "ran_pars.h"

void rinit( int n, double *a, int nodes, int me, long long *x1,
            long long *x2 )
// ---------------------------------------------------------------------
// -- 'rinit' sets up the 'nodes' streams of random numbers by
//    generating the parameters for each of them.
// ---------------------------------------------------------------------
{
   long long af1, af2, ci1, ci2;
   long long i, j;
   long long lx1, lx2;
// ---------------------------------------------------------------------
   ak1 = 1;
   ak2 = 1;
   ck1 = 0;
   ck2 = 0;
   for( i = 0; i < nodes; i++ ) {
      af1 = ak1;
      af2 = ak2;
      ak1 = ( a1*ak1 )%m1;
      ak2 = ( a2*ak2 )%m2;
      ci1 = 0;
      for( j = 0; j < c1; j++ ) {
         ci1 = ( ci1 + af1 )%m1;
      }
      ci2 = 0;
      for( j = 0; j < c2; j++ ) {
         ci2 = ( ci2 + af2 )%m2;
      }
      ck1 = ( ck1%m1 + ci1 )%m1;
      ck2 = ( ck2%m2 + ci2 )%m2;
   }
   lx1 = *x1; lx2 = *x2;
   for( i = 0; i < me + 97; i++ ) {    // -- Warming up phase.
      lx1 = ( a1*lx1 + c1 )%m1;
      lx2 = ( a2*lx2 + c2 )%m2;
   }
   a[me] = ( (double)lx1 + (double)lx2/m2 )/m1;
   *x1 = lx1; *x2 = lx2;
} // -- End of rinit
