#include "ran_pars.h"

double dran2( long long *x1, long long *x2 )
// ---------------------------------------------------------------------
// -- 'dran2' returns a uniform deviate in [0,1).
//    'dran2' is identical to Function dran0, except that the numbers
//    are generated with a spacing of 'k' elements in which k
//    is usually the number of processors in a parallel system
//    to be used.
//
// -- Input parameters:
//   long long - ak1, ck1, m1, ak2, ck2, m2. The parameters of the two
//               linear congruent relations used. They are passed
//               via 'ran_pars'.
//   long long - x1, x2. Seeds for the two linear congruences.
//               Passed via 'ran_pars'.
// 
// -- Output-parameters:
//    double   - 'ran'. Uniform deviate in [0,1)
// ---------------------------------------------------------------------
{
   long long lx1, lx2;
   double    ran;
// ---------------------------------------------------------------------
   lx1 = *x1; lx2 = *x2;
   lx1  = ( ak1*lx1 + ck1 )%m1;
   lx2  = ( ak2*lx2 + ck2 )%m2;
   ran = ( (double)lx1 + (double)lx2/m2 )/m1;
   *x1 = lx1; *x2 = lx2;
   return( ran );
} // -- End of dran2

