#include "ran_pars.h"

double dran0( long long *x1, long long *x2 )
// ---------------------------------------------------------------------
// -- 'dran0' returns a uniform deviate in [0,1).
//
// -- Input parameters:
//   long long - a1, c1, m1, a2, c2, m2. The parameters of the two
//               linear congruent relations used. They are passed
//               via 'ran_pars'.
//   long long - x1, x2. Seeds for the two linear congruences.
//               Passed via 'ran_pars'.
// 
// -- Output-parameters:
//    double   - 'ran'. Uniform deviate in [0,1)
// ---------------------------------------------------------------------
{
   long long lx1, lx2;
   double    ran;
// ---------------------------------------------------------------------
   lx1 = *x1; lx2 = *x2;
   lx1  = ( a1*lx1 + c1 )%m1;
   lx2  = ( a2*lx2 + c2 )%m2;
   ran = ( (double)lx1 + (double)lx2/m2 )/m1;
   *x1 = lx1; *x2 = lx2;
   return( ran );
}

